<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProductVariant extends Model {
    use HasFactory;
    protected $fillable = ['product_id','color','talla','genero','sku_variant'];

    public function product(){ return $this->belongsTo(Product::class); }
    //public function stock(){ return $this->hasOne(VariantStock::class, 'variant_id'); }

    public function attributeValues()
    {
        return $this->belongsToMany(AttributeValue::class, 'variant_attribute_values', 'variant_id', 'attribute_value_id');
    }

    public function stock() {
        return $this->hasOne(\App\Models\Stock::class, 'product_variant_id');
    }

    public function movements() {
        return $this->hasMany(\App\Models\StockMovement::class, 'product_variant_id')->latest();
    }
}
