<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Media extends Model {
    use HasFactory;
    protected $fillable = [
                            'product_id',
                            'path',
                            'is_primary',
                            'attributes_cache' => 'array', // para leer/escribir JSON
                          ];

    protected $casts = [
        'attributes_cache' => 'array', 
    ];

    public function product(){ return $this->belongsTo(Product::class); }

    public function attributeValues()
    {
        return $this->belongsToMany(
            AttributeValue::class,
            'product_media_attribute_values', // <-- pivot
            'product_media_id',               // <-- FK a media.id
            'attribute_value_id'
        )->withTimestamps();
    }

    // Sincroniza y refresca el cache JSON
    public function syncAttributeValues(array $valueIds): void
    {
        $this->attributeValues()->sync($valueIds);

        $data = $this->attributeValues()
            ->with('attribute:id,name,slug')
            ->get()
            ->map(fn($v) => [
                'attribute_id'   => $v->attribute_id,
                'attribute'      => $v->attribute?->name,
                'attribute_slug' => $v->attribute?->slug,
                'value_id'       => $v->id,
                'value'          => $v->name ?? $v->value ?? null,
                'value_slug'     => $v->slug,
            ])->values()->all();

        $this->attributes_cache = $data;
        $this->save();
    }
}
