<?php
// app/Models/Local.php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Local extends Model
{
    const MODE_PRODUCTS = 1;
    const MODE_SERVICES = 2;
    const MODE_MIXED    = 3;

    protected $casts = [
        'mode' => 'integer',
        'dynamic_pricing' => 'boolean',
        'active' => 'boolean',
    ];

    public function getModeLabelAttribute(): string {
        return [
            self::MODE_PRODUCTS => 'Solo venta',
            self::MODE_SERVICES => 'Solo servicios',
            self::MODE_MIXED    => 'Mixto',
        ][$this->mode] ?? '—';
    }

    protected $fillable = [
        'alias','name','description','url',
        'service_manual','dynamic_sale','sale_only',
    ];

    public function accountingPeriods()
    {
        return $this->hasMany(AccountingPeriod::class);
    }
}
