<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Currency extends Model
{
    protected $fillable = ['code','name','symbol','is_primary','rate_to_primary','is_active'];

    protected $casts = [
        'is_primary' => 'bool',
        'is_active'  => 'bool',
        'rate_to_primary' => 'decimal:6',
    ];

    public function scopeActive($q){ return $q->where('is_active', true); }
    public function scopePrimary($q){ return $q->where('is_primary', true); }

    /**
     * Convierte un monto desde ESTA moneda a OTRA.
     * amount * (from.rate_to_primary / to.rate_to_primary)
     */
    public function convertTo(self $to, float|int|string $amount): float
    {
        $fromR = (float)$this->rate_to_primary;
        $toR   = (float)$to->rate_to_primary;
        if ($toR <= 0) return 0.0;
        return (float)$amount * ($fromR / $toR);
    }

    public static function convert($amount, self $from, self $to): float
    {
        return $from->convertTo($to, $amount);
    }

    /** Orden para la barra: primaria primero, luego por code */
    public function scopeForRatesBar($q) {
        return $q->select('code','rate_to_primary','is_primary')
                 ->orderByDesc('is_primary')
                 ->orderBy('code');
    }
}
