<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Category extends Model {
    use HasFactory;
    protected $fillable = ['name','slug','parent_id'];

    public function parent(){ return $this->belongsTo(Category::class, 'parent_id'); }
    public function children(){ return $this->hasMany(Category::class, 'parent_id'); }
    public function products(){ return $this->hasMany(Product::class); }

    public function defaultAttributeValues()
    {
        // valores (subcategorías) por defecto de esta categoría
        return $this->belongsToMany(\App\Models\AttributeValue::class, 'attribute_value_category')
                    ->withTimestamps();
    }

    public function defaultAttributes() // (opcional, por comodidad)
    {
        return $this->defaultAttributeValues()->with('attribute');
    }
}
