<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class AttributeValue extends Model
{
    protected $fillable = ['attribute_id','value','slug'];

    public function attribute() { return $this->belongsTo(Attribute::class); }
    public function products()  { return $this->belongsToMany(Product::class, 'product_attribute_values'); }

    public function categories()
    {
        return $this->belongsToMany(\App\Models\Category::class, 'attribute_value_category')
                    ->withTimestamps();
    }

    public function media()
    {
        return $this->belongsToMany(
            Media::class,
            'product_media_attribute_values', // <-- pivot
            'attribute_value_id',
            'product_media_id'                // <-- FK a media.id
        )->withTimestamps();
    }
}