<?php

// app/Models/AccountingPeriod.php
namespace App\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;

class AccountingPeriod extends Model
{
    protected $fillable = [
        'local_id',
        'fecha_inicial', 'fecha_final',
        'descripcion',
        'cerrado', 'activo',
    ];

    protected $casts = [
        'fecha_inicial' => 'date',
        'fecha_final'   => 'date',
        'cerrado'       => 'boolean',
        'activo'        => 'boolean',
    ];

    public function local()
    {
        return $this->belongsTo(Local::class);
    }

    // Si tienes modelo Local, activa la relación:
    // public function local() { return $this->belongsTo(Local::class); }

    /* Scopes */
    public function scopeVigente(Builder $q): Builder {
        return $q->where('activo', true)->where('cerrado', false);
    }
    public function scopeDeLocal(Builder $q, $localId): Builder {
        return $q->where('local_id', $localId);
    }

    /* UI helpers */
    public function getEstadoBadgeAttribute(): array {
        if ($this->cerrado) return ['label'=>'Cerrado','class'=>'bg-gray-100 text-gray-700 ring-gray-200'];
        if ($this->activo)  return ['label'=>'Activo','class'=>'bg-emerald-50 text-emerald-700 ring-emerald-200'];
        return ['label'=>'Inactivo','class'=>'bg-slate-100 text-slate-700 ring-slate-200'];
    }

    public function dias(): int {
        return $this->fecha_inicial->diffInDays($this->fecha_final) + 1;
    }
}
