<?php

namespace App\Http\Requests\Zapatera;

use Illuminate\Foundation\Http\FormRequest;

class StockMovementRequest extends FormRequest
{
    public function authorize(): bool { return true; }

    public function rules(): array
    {
        return [
            'product_variant_id' => ['required','exists:product_variants,id'],
            'type' => ['required','in:in,out'],
            'qty'  => ['required','integer','min:1'],
            'note' => ['nullable','string','max:255'],
        ];
    }
}
