<?php

namespace App\Http\Requests\Zapatera;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class ProductUpdateRequest extends FormRequest
{
    public function authorize(): bool { return true; }

    public function rules(): array
    {
        $id = $this->route('product')->id ?? null;
        return [
            'category_id' => ['required','exists:categories,id'],
            'name'        => ['required','string','max:255'],
            'sku'         => ['required','string','max:64', Rule::unique('products','sku')->ignore($id)],
            'description' => ['nullable','string'],
            'cost'        => ['nullable','numeric','min:0'],
            'base_price'  => ['required','numeric','min:0'],
            'images.*'    => ['nullable','image','max:4096'],
            'primary_media_id' => ['nullable','integer'],
            'delete_media_ids' => ['nullable','array'],
            'delete_media_ids.*' => ['integer'],
            'attribute_values' => ['nullable','array'],
            'attribute_values.*' => ['integer','exists:attribute_values,id'],
            'barcode' => ['nullable','string','max:64','unique:products,barcode'.($this->product ? ','.$this->product->id : '')],
            'cost_currency_id'        => ['nullable','exists:currencies,id'],
            'base_price_currency_id'  => ['nullable','exists:currencies,id'],
        ];
    }
}
