<?php

namespace App\Http\Requests\Zapatera;

use Illuminate\Foundation\Http\FormRequest;

class ProductStoreRequest extends FormRequest
{
    public function authorize(): bool { return true; }

    public function rules(): array
    {
        return [
            'category_id' => ['required','exists:categories,id'],
            'name'        => ['required','string','max:255'],
            'sku'         => ['required','string','max:64','unique:products,sku'],
            'description' => ['nullable','string'],
            'cost'        => ['nullable','numeric','min:0'],
            'base_price'  => ['required','numeric','min:0'],
            'images.*'    => ['nullable','image','max:4096'],
            'primary_image_index' => ['nullable','integer','min:0'],
            'attribute_values' => ['nullable','array'],
            'attribute_values.*' => ['integer','exists:attribute_values,id'],
            'barcode' => ['nullable','string','max:64','unique:products,barcode'],
            'cost_currency_id'        => ['nullable','exists:currencies,id'],
            'base_price_currency_id'  => ['nullable','exists:currencies,id'],
        ];
    }
}
