<?php

namespace App\Http\Requests\Zapatera;

use Illuminate\Foundation\Http\FormRequest;

class GestorStoreRequest extends FormRequest
{
    public function authorize(): bool { return true; }

    public function rules(): array
    {
        return [
            'name' => ['required','string','max:120'],
            'token' => ['nullable','string','max:64','unique:gestors,token'],
            'uplift_pct_default' => ['required','numeric','min:0','max:100'],
            'phone' => ['nullable','string','max:40'],
            'is_active' => ['sometimes','boolean'],
        ];
    }

    protected function prepareForValidation(): void
    {
        $this->merge([
            'is_active' => (bool) $this->input('is_active', true),
        ]);
    }
}
