<?php

namespace App\Http\Requests\Zapatera;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class CategoryUpdateRequest extends FormRequest
{
    public function authorize(): bool { return true; }

    public function rules(): array
    {
        $id = $this->route('category')->id ?? null;
        return [
            'name' => ['required','string','max:100'],
            'slug' => ['nullable','string','max:120', Rule::unique('categories','slug')->ignore($id)],
            'description' => ['nullable','string'],
        ];
    }
}
