<?php

namespace App\Http\Requests\Zapatera;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class AttributeUpdateRequest extends FormRequest
{
    public function authorize(): bool { return true; }

    public function rules(): array
    {
        $id = $this->route('attribute')->id ?? null;
        return [
            'name' => ['required','string','max:100'],
            'slug' => ['nullable','string','max:120', Rule::unique('attributes','slug')->ignore($id)],
            'is_filterable' => ['sometimes','boolean'],
        ];
    }

    protected function prepareForValidation(): void
    {
        $this->merge([
            'is_filterable' => (bool) $this->input('is_filterable', true),
        ]);
    }
}
