<?php

namespace App\Http\Requests\Zapatera;

use Illuminate\Foundation\Http\FormRequest;

class AttributeStoreRequest extends FormRequest
{
    public function authorize(): bool { return true; }

    public function rules(): array
    {
        return [
            'name' => ['required','string','max:100'],
            'slug' => ['nullable','string','max:120','unique:attributes,slug'],
            'is_filterable' => ['sometimes','boolean'],
        ];
    }

    protected function prepareForValidation(): void
    {
        $this->merge([
            'is_filterable' => (bool) $this->input('is_filterable', true),
        ]);
    }
}
