<?php
// app/Http/Requests/LocalRequest.php
namespace App\Http\Requests;

use App\Models\Local;
use Illuminate\Foundation\Http\FormRequest;

class LocalRequest extends FormRequest
{
    public function authorize(): bool { return true; }

    public function rules(): array {
        return [
            'alias'  => ['required','string','max:50','unique:locals,alias,'.optional($this->local)->id],
            'name'   => ['required','string','max:100'],
            'url'    => ['nullable','url','max:200'],
            'description' => ['nullable','string','max:200'],
            'mode'   => ['required','in:1,2,3'],
            'dynamic_pricing' => ['boolean'],
            'active' => ['boolean'],
        ];
    }

    public function withValidator($v) {
        $v->after(function($v){
            // Ejemplo: si es solo productos, puedes forzar dynamic_pricing = false
            if ((int)$this->mode === Local::MODE_PRODUCTS && $this->boolean('dynamic_pricing')) {
                $v->errors()->add('dynamic_pricing','La venta dinámica no está disponible en “Solo venta”.');
            }
        });
    }
}
