<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class CurrencyUpdateRequest extends FormRequest
{
    public function authorize(): bool { return true; }

    public function rules(): array {
        $id = $this->route('currency')->id ?? null;
        return [
            'code'  => ['required','string','max:8', Rule::unique('currencies','code')->ignore($id)],
            'name'  => ['required','string','max:64'],
            'symbol'=> ['nullable','string','max:8'],
            'is_primary' => ['boolean'],
            'rate_to_primary' => ['required','numeric','gt:0'],
            'is_active' => ['boolean'],
        ];
    }
}
