<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CurrencyStoreRequest extends FormRequest
{
    public function authorize(): bool { return true; }

    public function rules(): array {
        return [
            'code'  => ['required','string','max:8','unique:currencies,code'],
            'name'  => ['required','string','max:64'],
            'symbol'=> ['nullable','string','max:8'],
            'is_primary' => ['boolean'],
            'rate_to_primary' => ['required','numeric','gt:0'],
            'is_active' => ['boolean'],
        ];
    }
}
