<?php
namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;

class SettingsUpdateRequest extends FormRequest
{
    public function authorize(): bool
    {
        return $this->user()?->hasRole('admin') ?? false;
    }

    public function rules(): array
    {
        return [
            'inventory.totals.render_type'     => ['required','in:simple,complex'],
            'inventory.totals.raw'             => ['required','boolean'],
            'inventory.totals.only_with_stock' => ['required','boolean'],
            // agrega más claves aquí si quieres validación estricta
        ];
    }

    protected function prepareForValidation(): void
    {
        // normaliza true/false de checkboxes
        $this->merge([
            'inventory' => [
                'totals' => [
                    'render_type'     => $this->input('inventory.totals.render_type'),
                    'raw'             => filter_var($this->input('inventory.totals.raw'), FILTER_VALIDATE_BOOLEAN),
                    'only_with_stock' => filter_var($this->input('inventory.totals.only_with_stock'), FILTER_VALIDATE_BOOLEAN),
                ]
            ]
        ]);
    }
}
