<?php

namespace App\Http\Controllers\Zapatera;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Gestor;

class GestorPanelController extends Controller
{
    public function index(Request $request)
    {
        // Si tienes auth: $gestor = Gestor::where('user_id', auth()->id())->first();
        // Por ahora: demo con token fijo o query 'g'
        $token = $request->query('g', 'GESTOR123');

        $gestor = Gestor::where('token', $token)->first();
        // Defaults si no existe en BD:
        $gestorData = [
            'token' => $gestor->token ?? $token,
            'uplift_pct_default' => $gestor->uplift_pct_default ?? 10,
            'phone' => $gestor->phone ?? '+34999999999',
        ];

        // URL de publicación (catálogo con token y uplift)
        $publishUrl = url('/zapatera/catalogo') . '?g=' . $gestorData['token'] . '&p=' . $gestorData['uplift_pct_default'] . '&wa=' . urlencode($gestorData['phone']);

        return view('zapatera.gestor.index', [
            'gestor' => (object) $gestorData,
            'publishUrl' => $publishUrl,
        ]);
    }

    public function save(Request $request)
    {
        // Placeholder para cuando quieras persistir cambios del gestor
        $request->validate([
            'token' => ['required','string'],
            'uplift' => ['required','numeric','min:0','max:100'],
            'phone' => ['nullable','string'],
        ]);

        // Aquí guardas en DB si lo deseas…
        return back()->with('status','Configuración guardada (demo)');
    }
}
