<?php

namespace App\Http\Controllers\Zapatera;

use App\Http\Controllers\Controller;
use App\Models\Product;

class CatalogGalleryController extends Controller
{
    public function show(Product $product)
    {
        $media = $product->media()
            ->orderByDesc('is_primary')
            ->orderBy('id')
            ->get();

        $initialIndex = (int) request('i', 0);
        if ($initialIndex < 0 || $initialIndex >= max(1, $media->count())) {
            $initialIndex = 0;
        }

        // Si pidieron el EMBED (AJAX en modal), devolvemos parcial sin layout
        if (request()->boolean('embed')) {
            return view('zapatera.admin.products.gallery_embed', compact('product','media','initialIndex'));
        }

        // Si no, devolvemos la página completa
        return view('zapatera.admin.products.gallery', compact('product','media','initialIndex'));
    }
}
