<?php

namespace App\Http\Controllers\Zapatera;

use App\Http\Controllers\Controller;
use App\Models\Product;
use Picqer\Barcode\BarcodeGeneratorSVG;

class BarcodeController extends Controller
{
    public function show(Product $product)
    {
        abort_if(empty($product->barcode), 404, 'El producto no tiene código de barra.');
        $gen = new \Picqer\Barcode\BarcodeGeneratorSVG();
        $svg = $gen->getBarcode($product->barcode, $gen::TYPE_CODE_128, 2, 60);
        return response($svg, 200)->header('Content-Type', 'image/svg+xml');
    }

    public function preview(string $code)
    {
        $gen = new \Picqer\Barcode\BarcodeGeneratorSVG();
        $svg = $gen->getBarcode($code, $gen::TYPE_CODE_128, 2, 60);
        return response($svg,200)->header('Content-Type','image/svg+xml');
    }
}