<?php

namespace App\Http\Controllers\Zapatera;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use Spatie\Permission\Models\Role;

class AdminUserRoleController extends Controller
{
    public function __construct()
    {
        $this->middleware(['auth','verified','role:admin']);
    }

    public function index(Request $request)
    {
        $q = $request->get('q');
        $users = User::query()
            ->when($q, fn($qq)=>$qq->where(function($w) use($q){
                $w->where('name', 'like', "%$q%")
                  ->orWhere('email','like', "%$q%");
            }))
            ->orderBy('name')
            ->paginate(20)
            ->withQueryString();

        return view('zapatera.admin.users.index', compact('users','q'));
    }

    public function edit(User $user)
    {
        $roles = Role::orderBy('name')->pluck('name')->all();
        return view('zapatera.admin.users.roles', compact('user','roles'));
    }

    public function update(Request $request, User $user)
    {
        $data = $request->validate([
            'roles'   => ['array'],
            'roles.*' => ['string','exists:roles,name'],
        ]);
        $roles = $data['roles'] ?? [];

        // Seguridad: no permitir que un admin se quite a sí mismo el rol admin
        if ($user->id === auth()->id() && ! in_array('admin', $roles, true)) {
            return back()->withErrors('No puedes quitarte tu propio rol de administrador.');
        }

        $user->syncRoles($roles);

        return redirect()
            ->route('zapatera.admin.users.index')
            ->with('status', 'Roles actualizados');
    }
}
