<?php
// app/Http/Controllers/Zapatera/AdminLocalController.php
namespace App\Http\Controllers\Zapatera;

use App\Http\Controllers\Controller;
use App\Http\Requests\LocalRequest;
use App\Models\Local;
use Illuminate\Http\Request;

class AdminLocalController extends Controller
{
    public function index(Request $request)
    {
        $q = trim($request->string('q')->toString());

        $perPage = (int) request('per_page', 15);
        $locals = Local::query()
            ->when($q, function ($query) use ($q) {
                $query->where(function($w) use ($q) {
                    $w->where('name','like',"%{$q}%")
                      ->orWhere('alias','like',"%{$q}%")
                      ->orWhere('description','like',"%{$q}%");
                });
            })
            ->orderBy('name')
            ->paginate($perPage)
            ->withQueryString();

        return view('zapatera.admin.locals.index', compact('locals','q'));
    }

    public function create()
    {
        $local = new Local();
        return view('zapatera.admin.locals.create', compact('local'));
    }

    public function store(LocalRequest $request)
    {
        Local::create($request->validated());
        return redirect()
            ->route('zapatera.admin.locals.index')
            ->with('status','Local creado correctamente.');
    }

    public function edit(Local $local)
    {
        return view('zapatera.admin.locals.edit', compact('local'));
    }

    public function update(LocalRequest $request, Local $local)
    {
        $local->update($request->validated());
        return redirect()
            ->route('zapatera.admin.locals.index')
            ->with('status','Local actualizado.');
    }

    public function destroy(Local $local)
    {
        $local->delete();
        return back()->with('status','Local eliminado.');
    }
}
