<?php

namespace App\Http\Controllers\Zapatera;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use App\Models\Gestor;
use App\Http\Requests\Zapatera\{GestorStoreRequest, GestorUpdateRequest};

class AdminGestorController extends Controller
{
    public function __construct()
    {
        $this->authorizeResource(Gestor::class, 'gestor');
    }

    public function index(Request $request)
    {
        $q = $request->get('q');
        $gestors = Gestor::query()
            ->when($q, function($query) use ($q){
                $query->where(function($w) use ($q){
                    $w->where('name','like',"%$q%")
                      ->orWhere('token','like',"%$q%");
                });
            })
            ->orderBy('name')
            ->paginate(20)
            ->withQueryString();

        return view('zapatera.admin.gestors.index', compact('gestors','q'));
    }

    public function create()
    {
        $gestor = new Gestor();
        $gestor->uplift_pct_default = 10;
        $gestor->is_active = 1;
        return view('zapatera.admin.gestors.create', compact('gestor'));
    }

    public function store(GestorStoreRequest $request)
    {
        $data = $request->validated();
        if (empty($data['token'])) {
            $data['token'] = strtoupper(Str::random(8));
        }
        Gestor::create($data);
        return redirect()->route('zapatera.admin.gestors.index')->with('status','Gestor creado');
    }

    public function edit(Gestor $gestor)
    {
        return view('zapatera.admin.gestors.edit', compact('gestor'));
    }

    public function update(GestorUpdateRequest $request, Gestor $gestor)
    {
        $gestor->update($request->validated());
        return redirect()->route('zapatera.admin.gestors.edit',$gestor)->with('status','Gestor actualizado');
    }

    public function destroy(Gestor $gestor)
    {
        $gestor->delete();
        return redirect()->route('zapatera.admin.gestors.index')->with('status','Gestor eliminado');
    }

    public function regenerateToken(Gestor $gestor)
    {
        $gestor->token = strtoupper(Str::random(10));
        $gestor->save();
        return back()->with('status','Token regenerado: '.$gestor->token);
    }
}
