<?php

namespace App\Http\Controllers\Zapatera;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use App\Models\{Attribute, AttributeValue};
use App\Http\Requests\Zapatera\{AttributeValueStoreRequest, AttributeValueUpdateRequest};

class AdminAttributeValueController extends Controller
{
    public function index(Attribute $attribute)
    {
        $values = $attribute->values()->orderBy('value')->paginate(50)->withQueryString();
        return view('zapatera.admin.attribute_values.index', compact('attribute','values'));
    }

    public function store(AttributeValueStoreRequest $request, Attribute $attribute)
    {
        $data = $request->validated();
        if (empty($data['slug'])) {
            $data['slug'] = Str::slug($data['value']);
        }
        $data['attribute_id'] = $attribute->id;
        AttributeValue::create($data);

        return back()->with('status','Valor creado');
    }

    public function edit(Attribute $attribute, AttributeValue $value)
    {
        return view('zapatera.admin.attribute_values.edit', [
            'attribute' => $attribute,
            'value' => $value,
        ]);
    }

    public function update(AttributeValueUpdateRequest $request, Attribute $attribute, AttributeValue $value)
    {
        $data = $request->validated();
        if (empty($data['slug'])) {
            $data['slug'] = Str::slug($data['value']);
        }
        $value->update($data);

        return redirect()->route('zapatera.admin.attributes.values.index', $attribute)
            ->with('status','Valor actualizado');
    }

    public function destroy(Attribute $attribute, AttributeValue $value)
    {
        if ($value->products()->exists()) {
            return back()->with('status','No se puede eliminar: el valor está asociado a productos.');
        }
        $value->delete();
        return back()->with('status','Valor eliminado');
    }
}
