<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Product;

class ProductStockController extends Controller
{
    public function index(Product $product)
    {
        $stocks = $product->stocks()->get()->map(function($s){
            return [
                'id'          => $s->id,
                'qty'         => $s->qty,
                'attributes'  => $s->attribute_values,
                'descripcion' => $s->descripcion,
            ];
        });
        return response()->json($stocks);
    }
}
