<?php
namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Product;

class ProductController extends Controller
{
    public function variants(Product $product)
    {
        $variants = $product->variants()->with('attributeValues.attribute')->get()->map(function($v) {
            return [
                'id' => $v->id,
                'descripcion' => $v->attributeValues->map(function($av){
                    return $av->attribute->name . ': ' . $av->name;
                })->implode(' / '),
            ];
        });

        return response()->json($variants);
    }
}
