<?php

// app/Http/Controllers/Api/ProductAttributeController.php
namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Product;

class ProductAttributeController extends Controller
{
    /**
     * Devuelve los atributos y sus valores para un producto.
     * Formato:
     * [
     *   { name: "Color", values: ["Rojo", "Blanco", "Negro"] },
     *   { name: "Talla", values: ["39","41","44"] }
     * ]
     */
    public function attributes(Product $product)
    {
        $attributes = $product->attributes()->with('values')->get()->map(function($attr){
            return [
                'name' => $attr->name,
                'values' => $attr->values->pluck('name')->toArray(),
            ];
        });

        return response()->json($attributes);
    }
}
