<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use File;

class LogsClear extends Command
{
    protected $signature = 'logs:clear';
    protected $description = 'Clear all log files in storage/logs';

    public function handle()
    {
        $files = File::glob(storage_path('logs/*.log'));
        foreach ($files as $file) {
            file_put_contents($file, '');
        }

        $this->info('✅ Logs limpiados correctamente.');
    }
}
