# Plantilla Laravel 10 + Vite + Bootstrap 5.3.3 (Local sin CDN)

Esta plantilla te prepara un proyecto **Laravel 10 / PHP 8.1** con **Bootstrap 5.3.3 vía npm + Vite** en local (sin CDN) y con un **toggle por .env** (`BOOTSTRAP_CDN=true|false`) para que en producción puedas usar CDN si lo prefieres.

## Pasos (Windows / macOS / Linux)

### 0) Requisitos
- PHP 8.1+
- Composer
- Node 18+ y npm
- (Opcional) Git

### 1) Crear proyecto Laravel 10
```bash
composer create-project laravel/laravel zapatera
cd zapatera
```

### 2) Copiar esta plantilla encima del proyecto
Descomprime el ZIP en la carpeta raíz del proyecto `zapatera` y **acepta merge** de carpetas.

### 3) Instalar dependencias front
```bash
npm i
npm i bootstrap@5.3.3 @popperjs/core
```

### 4) Configurar .env
Abre `.env` y **añade/ajusta**:
```
APP_NAME="Zapatera"
BOOTSTRAP_CDN=false
```
> En producción puedes poner `BOOTSTRAP_CDN=true` si quieres cargar Bootstrap por CDN.

### 5) Vite (desarrollo)
```bash
npm run dev
```
**Y en otra terminal**:
```bash
php artisan serve
```
Abre `http://127.0.0.1:8000`.

---

## ¿Qué trae?
- `resources/css/app_local.css`: importa Bootstrap desde `node_modules` y tu tema `app.css`.
- `resources/css/app.css`: variables y estilos de tema (paleta azul marino + gris + blanco).
- `resources/js/app.js`: inicializa Bootstrap y tu JS.
- `resources/views/layouts/app.blade.php`: layout con **toggle** `BOOTSTRAP_CDN` para CDN vs local.
- `resources/views/pages/home.blade.php`: página de ejemplo con hero y tarjetas.
- `routes/web.php` (fragmento sugerido): ruta `/` que devuelve la home.
- `vite.config.js`: configuración estándar con alias `@` a `resources`.
- `scripts/setup_windows.bat` y `scripts/setup_mac_linux.sh`: scripts opcionales con los comandos.

> Si ya tienes tu maqueta estática, pega tus vistas dentro de `resources/views/...` y tu CSS sobre `resources/css/app.css`.

---

## Ruta sugerida para catálogo/ERP
- Crea controladores y vistas dentro de `app/Http/Controllers/Zapatera` y `resources/views/zapatera/...`.
- Cuando migres a base de datos, añade modelos, migraciones y seeders; mantén el toggle de Bootstrap para local/producción.

¡Listo! Arranca tu app con `php artisan serve` y Vite con `npm run dev`.
